package gov.va.med.mhv.calendar.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.calendar.dto.ReminderDetailsDTO;
import gov.va.med.mhv.calendar.model.ReminderDetails;
import org.springframework.core.convert.converter.Converter;

public class ReminderDetailsConverter implements Converter<ReminderDetails, ReminderDetailsDTO> {

	@Override
	public ReminderDetailsDTO convert(ReminderDetails source) {
		ReminderDetailsDTO target = new ReminderDetailsDTO();
		
		target.setId(source.getId());
		target.setReminderType(source.getReminderType());
		target.setReferenceKey(source.getReferenceKey());
		target.setReferenceId(source.getReferenceId());
		target.setReminderOffset(source.getReminderOffset());
		target.setInfo(source.getInfo());

		return target;
	}
	
	public ReminderDetails convert(ReminderDetailsDTO source) {
		ReminderDetails target = new ReminderDetails();
		
		target.setId(source.getId());
		target.setReminderType(source.getReminderType());
		target.setReferenceKey(source.getReferenceKey());
		target.setReferenceId(source.getReferenceId());
		target.setReminderOffset(source.getReminderOffset());
		target.setInfo(source.getInfo());

		return target;
	}
	
	public List<ReminderDetailsDTO> convert(List<ReminderDetails> source) {
		List <ReminderDetailsDTO> reminderDetailsDto= null;
		if(null !=source) {
			reminderDetailsDto = new ArrayList<ReminderDetailsDTO>();

			for (ReminderDetails reminderDetails: source) {
				reminderDetailsDto.add(this.convert(reminderDetails));
			}

		}

		return reminderDetailsDto;
	}

}
